<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CFaq extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "faq") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "detect":
					return $this->Landing();
				break;

				case "category":
					return $this->Category();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"categories"			=> "categories.htm",
			"category"				=> "category.htm",
			"onepage"				=> "onepage.htm",
			"items"					=> "items.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {

		global $base;
		
		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_cats']} as p , 
				{$this->tables['plugin:faq_cats_lang']} as l
			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				cat_status = 1 AND
				l.cat_url LIKE '%s' AND
				cat_date < %d
			",
			array(
				$_GET["cat_url"],
				time()
			)
		);

		
		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"]						=> $this->tpl_module["mod_name"],
			$this->tpl_module["link"] . "{$cat[cat_url]}/"	=> $cat["cat_title"]
		));


		if (!is_array($cat)) {

			if ($this->detected) {
				return "";
			} else {		
				return $this->module->plugins["redirects"]->ErrorPage("404" , true);
			}
		}


		$this->plugins["seo"]->PageMeta($cat);
		$this->plugins["seo"]->Canonical($this->tpl_module["link"] . $cat["cat_url"] . "/");


		$items = $this->_GetItemsPage(
			"
				{$this->tables['plugin:faq_items']} as p , 
				{$this->tables['plugin:faq_items_lang']} as l
			",
			99999 , 
			$_GET["page"],
			"	
				p.item_id = l.item_id and 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				find_in_set({$cat[cat_id]}  , p.item_cat) AND 
				p.item_status = 1
			",
			"item_order ASC"
		);


		if (is_array($items["records"])) {
			foreach ($items["records"] as $key => $val) {
				$items["records"][$key]["icon"] = $this->_t("items")->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val );
			}			
		}
		
		$this->SetComments($this->tpl_module["settings"]["set_comments_details"]);

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),
			$this->_t("category")->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$this->_t("items"), 
						"Body" , 
						$items["records"]
					),

					"items_titles"	=> $base->html->Table(
						$this->_t("items"), 
						"" , 
						$items["records"]
					),

					"head"	=> $this->tpl_module["settings"]["set_title"] ? $this->_t("category")->blockReplace("Head" , $cat) : "",

				),
				$cat,
				$text ,
				$this->tpl_module

			)
		);

	}
	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);

		if ($module["settings"]["set_style"] != "2") {
			$cats = $this->db->QFetchRowArray(

				"SELECT * FROM 
					{$this->tables['plugin:faq_cats']} as c,
					{$this->tables['plugin:faq_cats_lang']} as l
				WHERE
					c.module_id={$module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$module[lang_id]} AND
					cat_date < %d
				ORDER BY
					c.cat_order ASC
				",
				array( time() )
			);

			if (is_array($cats)) {
				foreach ($cats as $key => $val) {
					$links[] = array(
						"url"	=> $module["link"] . $val["cat_url"] . "/"
					);
				}				
			}

		}

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Detect() {
		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_cats']} as p , 
				{$this->tables['plugin:faq_cats_lang']} as l

			WHERE 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				p.module_id = {$this->tpl_module[mod_id]} AND 
				cat_status = 1 AND 
				cat_date < %d
			ORDER BY 
				cat_order ASC
			LIMIT 1",
			array(
				time()
			)
		);

		
		$_GET["cat_url"] = $cat["cat_url"];

		$this->detected = true;
	}
	

	function GetMenuButton($module) { 

		if ($module["settings"]["set_style"] == "2") {
			$module["settings"]["set_menu_style"] = 0;
		}
		

		switch ($module["settings"]["set_menu_style"]) {
			default:
				return parent::GetMenuButton($module);
			break;

			case "2":

				if ($module["settings"]["set_menu_cats"]) {
					$cond = " AND i.cat_id IN (" . $module["settings"]["set_menu_cats"] . ")";
				}
				
			case "1":
				$items = $this->db->QFetchRowArray(
					"SELECT * " . 
					"FROM 
						{$this->tables['plugin:faq_cats']} as i,
						{$this->tables['plugin:faq_cats_lang']} as il
					WHERE 				
						i.cat_id = il.cat_id AND 
						il.lang_id={$module[lang_id]} AND 
						i.module_id={$module[mod_id]} AND 
						cat_status = 1 AND 
						cat_date < %d
						{$cond}

					ORDER BY  cat_order ASC",
					array(
						time()
					)
				);


				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$sub[] = array(
							"title"		=> $val["cat_title"],
							"link"		=> $module["link"] . $val["cat_url"] . "/ ",
							"selected"	=> ($module["mod_id"] == $val["module_id"] ) && ( $val["cat_url"] == $_GET["cat_url"]) ? true : false,
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					}
				
				}

				return parent::GetMenuButton(
					$module , 
					array( 
						"html"	=> $this->plugins["menus"]->dropDownHTML(								
							array(
								"size"		=> $module["settings"]["set_menu_cols"],
								"id"		=> $module["mod_id"],
								"bg"		=> $module["settings"]["set_menu_bg"],
								"title"		=> $module["mod_name"],
							),
							$sub
						)
					)
				);
			
			break;

		}				
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		switch ($this->tpl_module["settings"]["set_style"]) {
			//categories listing
			default:
				return $this->Categories();
			break;

			//skip listing
			case "1":
				$this->Detect();
				return $this->Category();
			break;

			//onepage
			case "2":
				return $this->OnePage();
			break;

		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Categories() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);


		$template = &$this->private->templates["categories"];

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_cats']} as c,
				{$this->tables['plugin:faq_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND
				cat_date < %d

			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);


		$cats = $this->processItems($cats , $template);
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"] , array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$template,
						"" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
		

	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($cats , $template , $module = null) {

		if (!$module) {
			$module = $this->tpl_module;
		}		


		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$val["link"] = $module["link"] . $val["cat_url"] . "/";
				$cats[$key]["icon"] = $template->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);

				$cats[$key]["button"] = $module["settings"]["set_elements"] == "1" ? $template->blockReplace(
					"Button",
					array(
						"size"	=> $module["settings"]["set_button_size"],
						"style"	=> $style,

						"link"	=> $val["link"] , 
						"text"	=> $btn,
						
					)
				) : "";	

				$cats[$key]["title"] = $template->blockReplace("TitleLink" , $val);

				$cats[$key]["image"] = "";

				switch ($val["cat_tn_type"]) {
					//image
					case "1":
						$cats[$key]["image"] = $val["cat_tn_image"] ? $template->blockREplace("TnImageLink" , $val) : "";
					break;

					//icon
					default:
					case "2":
						$cats[$key]["image"] = $val["cat_tn_icon"] ? $template->blockREplace("TnIconLink", $val) :"";
					break;
				}
				
			}			
		}

		return $cats;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OnePage() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);



		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_cats']} as c,
				{$this->tables['plugin:faq_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND
				cat_date < %d

			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);

		if (is_Array($cats)) {
			foreach ($cats as $key => $val) {
				$items = $this->db->QFetchRowArray("
					SELECT * FROM 
						{$this->tables['plugin:faq_items']} as p , 
						{$this->tables['plugin:faq_items_lang']} as l
					WHERE
						p.item_id = l.item_id and 
						l.lang_id = {$this->tpl_module[lang_id]} AND 
						find_in_set({$val[cat_id]}  , p.item_cat) AND 
						p.item_status = 1
				");

				if (is_array($items)) {
					foreach ($items as $k => $v) {
						$items[$k]["icon"] = $this->_t("items")->blockReplace($v["item_icon"] ? "Icon" : "NoIcon", $v);
					}			
				}


				$cats[$key]["questions"] = $base->html->table(
					$this->_t("items"),
					"Body",
					$items,
					$val
				);

				$cats[$key]["head"] = $val["cat_description"]? $this->_t("onepage")->blockReplace(
					"CatHeader",
					$val
				) : "";

				$cats[$key]["title"] = $this->tpl_module["settings"]["set_title"] ? $this->_t("onepage")->blockReplace(
					"CatTitle",
					$val
				) : "";

			}
			
		}
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"] , array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$this->_t("onepage")->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$this->_t("onepage"),
						"Cats" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $this->_t("onepage")->blockReplace("MainTitle" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}

	

	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		if (!in_array($module["settings"]["set_style"] , array("2" ))) {	

			$cats = $this->db->QFetchRowArray(

				"SELECT * FROM 
					{$this->tables['plugin:faq_cats']} as c,
					{$this->tables['plugin:faq_cats_lang']} as l
				WHERE
					c.module_id={$module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$module[lang_id]} AND 
					cat_date < %d
				ORDER BY
					c.cat_order ASC
				",
				array( time() )
			);

			if (is_array($cats)) {
				foreach ($cats as $key => $val) {
					$links[] = array(
						"url"	=> $module["link"] . $val["cat_url"] . "/"
					);
				}				
			}
		}

	}


}
